IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_ETL_Fact_Scheduled_Admission_Delete]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ufn_ETL_Fact_Scheduled_Admission_Delete]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE FUNCTION [dbo].[ufn_ETL_Fact_Scheduled_Admission_Delete](@START_DATE DATETIME, @END_DATE DATETIME)
RETURNS TABLE 
AS
RETURN
(
	SELECT BSA.ID as [SOURCE_ID]
	FROM [BMS_SCHEDULED_ADMISSION] AS BSA
	WHERE BSA.[_isDeleted] = 1 AND BSA.[_ssis_timestamp] > @START_DATE 
		AND BSA.[_ssis_timestamp] < @END_DATE
)
GO

